/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.projectile;

import com.renyigesai.immortalers_delight.ImmortalersDelightMod;
import com.renyigesai.immortalers_delight.client.particle.ShockWaveParticleOption;
import com.renyigesai.immortalers_delight.entities.projectile.EffectCloudBaseEntity;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightParticleTypes;
import com.renyigesai.immortalers_delight.potion.GasPoisonMobEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GasCloudEntity
extends EffectCloudBaseEntity {
    private static final Vec3[] COLORS = (Vec3[])Util.m_137469_((Object)new Vec3[16], p_154319_ -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            p_154319_[i] = new Vec3((double)f1, (double)f2, (double)f3);
        }
    });

    public GasCloudEntity(EntityType<? extends GasCloudEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public GasCloudEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends GasCloudEntity>)((EntityType)ImmortalersDelightEntities.GAS_EFFECT_CLOUD.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    @Override
    protected void updateParticles(float range) {
        super.updateParticles(range);
        if (!this.isDangerous()) {
            return;
        }
        if (this.lifeTicks <= this.getWaitTime()) {
            int a = (int)(range * 2.0f);
            DustParticleOptions particleoptions = new DustParticleOptions(COLORS[a].m_252839_(), 1.0f);
            int i = 360 / this.getWaitTime();
            float f1 = range;
            for (int j = 0; j < i; ++j) {
                float lastAngle = (float)(this.lifeTicks - 1) / (float)this.getWaitTime();
                float f2 = ((float)j / (float)(this.getWaitTime() * i) + lastAngle) * ((float)Math.PI * 2);
                float f3 = f1 * 2.0f;
                double d0 = this.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
                double d2 = this.m_20186_() + 0.1;
                double d4 = this.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                this.m_9236_().m_7107_((ParticleOptions)particleoptions, d0, d2, d4, d5, d6, d7);
            }
        }
        if (this.lifeTicks == this.getWaitTime()) {
            ParticleOptions particleoptions = (ParticleOptions)ImmortalersDelightParticleTypes.GAS_SMOKE.get();
            int i = Mth.m_14167_((float)((float)Math.PI * range * range));
            float f1 = range - 0.2f;
            for (int j = 0; j < 2 * i; ++j) {
                if (j < i) {
                    float f2 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f3 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f1;
                    double d0 = this.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
                    double d2 = this.m_20186_() + 0.25;
                    double d4 = this.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
                    double d5 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                    double d6 = 0.01f;
                    double d7 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                    this.m_9236_().m_7107_(particleoptions, d0, d2, d4, d5, d6, d7);
                }
                double d0 = this.m_20185_() + (0.5 - this.f_19796_.m_188500_()) * 0.15;
                double d2 = this.m_20186_() + 0.35;
                double d4 = this.m_20189_() + (0.5 - this.f_19796_.m_188500_()) * 0.15;
                float f2 = (float)j / (float)(2 * i) * ((float)Math.PI * 2);
                float f3 = 0.25f + 0.1f * f1;
                double d5 = Mth.m_14089_((float)f2) * f3;
                double d6 = -0.05f;
                double d7 = Mth.m_14031_((float)f2) * f3;
                this.m_9236_().m_7107_(this.getParticle(), d0, d2, d4, d5, d6, d7);
            }
        }
    }

    @Override
    public void doOnStart(float range) {
        int pr = (int)Math.max(this.getRadius() * 2.0f - 3.0f, -1.0f);
        GasCloudEntity.spawnShriekParticle(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), pr, 0);
    }

    @Override
    protected void doOnAddEffect(LivingEntity livingentity, List<MobEffectInstance> list) {
        if (livingentity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ImmortalersDelightItems.GOLDEN_FABRIC_VEIL.get())) {
            livingentity.m_6844_(EquipmentSlot.HEAD).m_41622_(this.isDangerous() ? 3 : 1, livingentity, action -> action.m_21166_(EquipmentSlot.HEAD));
        } else {
            super.doOnAddEffect(livingentity, list);
        }
    }

    @Override
    protected boolean doAdditionalAction(float range) {
        if (!this.isDangerous()) {
            return false;
        }
        List list1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)this.getRadius()));
        if (!list1.isEmpty()) {
            boolean flag = false;
            for (LivingEntity livingentity : list1) {
                Level level;
                double d1;
                LivingEntity caster = this.getOwner();
                if (!livingentity.m_6084_() || this.victims.containsKey(livingentity) || livingentity == caster || !(livingentity instanceof Sniffer) && caster != null && (caster.m_7307_((Entity)livingentity) || livingentity.m_7307_((Entity)caster))) continue;
                double d8 = livingentity.m_20185_() - this.m_20185_();
                double d3 = d8 * d8 + (d1 = livingentity.m_20189_() - this.m_20189_()) * d1;
                if (d3 <= (double)(range * range)) {
                    if (!livingentity.m_21023_((MobEffect)ImmortalersDelightMobEffect.GAS_POISON.get()) && !livingentity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ImmortalersDelightItems.GOLDEN_FABRIC_VEIL.get())) {
                        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
                        if (isPowerful) {
                            livingentity.f_19802_ = 0;
                        }
                        livingentity.m_6469_(GasPoisonMobEffect.getDamageSource((Entity)livingentity, (Entity)caster), 2.0f);
                        if (isPowerful) {
                            livingentity.f_19802_ = 0;
                        }
                        if (isPowerful && livingentity instanceof Mob) {
                            Mob mob = (Mob)livingentity;
                            mob.m_21573_().m_5624_((Entity)this, 0.3);
                        }
                    }
                    flag = true;
                    continue;
                }
                if (!(livingentity instanceof Sniffer)) continue;
                Sniffer sniffer = (Sniffer)livingentity;
                if (!(d3 <= (double)(2.0f * range * 2.0f * range))) continue;
                this.victims.put(livingentity, this.f_19797_ + this.reapplicationDelay);
                sniffer.m_6274_().m_21882_(MemoryModuleType.f_217772_, (Object)Unit.INSTANCE, 96L);
                BlockPos pos = sniffer.m_21573_().m_26567_();
                if (pos != null) {
                    sniffer.m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 3.0);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    GasCloudEntity.spawnShriekParticle((Level)serverLevel, sniffer.m_20185_(), sniffer.m_20188_(), sniffer.m_20189_(), 0, 1);
                }
                flag = true;
                if (!(caster instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)caster;
                ImmortalersDelightMod.PASS_SNIFFER_COOLDOWN_TRIGGER.trigger(serverPlayer);
            }
            return flag;
        }
        return false;
    }

    public static void spawnShriekParticle(Level level, double x, double y, double z, int delay, int type) {
        if (level == null) {
            return;
        }
        if (type == 0) {
            ServerLevel serverLevel;
            ShockWaveParticleOption particleOption = new ShockWaveParticleOption(delay);
            if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_5776_()) {
                serverLevel.m_8767_((ParticleOptions)particleOption, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            } else if (level.m_5776_()) {
                System.out.println("\u751f\u6210\u51b2\u51fb\u6ce2\u7c92\u5b50");
                level.m_7107_((ParticleOptions)particleOption, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (type == 1) {
            for (int i = 0; i < 25; ++i) {
                ServerLevel serverLevel;
                SimpleParticleType particleOption;
                Object object = particleOption = i % 5 == 0 ? (ParticleOptions)ImmortalersDelightParticleTypes.SNIFFER_FUR.get() : ParticleTypes.f_123792_;
                if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_5776_()) {
                    serverLevel.m_8767_((ParticleOptions)particleOption, x - 1.0 + (double)(level.f_46441_.m_188501_() * 2.0f), y - 0.5 + (double)level.f_46441_.m_188501_(), z - 1.0 + (double)(level.f_46441_.m_188501_() * 2.0f), 1, 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                if (!level.m_5776_()) continue;
                level.m_7107_((ParticleOptions)particleOption, x - 1.0 + (double)(level.f_46441_.m_188501_() * 2.0f), y - 0.5 + (double)level.f_46441_.m_188501_(), z - 1.0 + (double)(level.f_46441_.m_188501_() * 2.0f), 0.0, 0.0, 0.0);
            }
        }
    }
}

